%%%%%%%%%%%% The codes used for the advec_paper 2018 %%%%%%%%%%%%
%% Example 1
% Fig.1: OK
LW = 'linewidth';lw = 1.6;
clf
subplot(2,1,1)
plot(chebfun('0.51+sin(x-1).^2',[0,2*pi]),LW,lw)
xlabel('$x$','interpreter','latex')
ylabel('$c(x)$','interpreter', 'latex')
title('Variable coefficient')
subplot(2,1,2)
plot(chebfun('exp(-100*(x-1).^2)',[0,2*pi]),LW,lw)
xlabel('$x$','interpreter','latex'), ylabel('$u_0(x)$','interpreter', 'latex')
title('Initial function')
clear

%% Fig.2: OK
figure
profile_ex1
clear

%% Fig.3, 4: OK
load example1_result_20180720_200647.mat% This data is given by "advection_loop.m"
plotzu_ex1

%% Table 1: OK
disp('Table 1')
make_table_ex1

%% Example 2
% Fig.5: OK
figure
LW = 'linewidth';lw = 1.6;
clf
subplot(2,1,1)
plot(chebfun('1+0.49*cos(2*x)',[0,2*pi]),LW,lw)
xlabel('$x$','interpreter','latex')
ylabel('$c(x)$','interpreter', 'latex')
title('Variable coefficient')
subplot(2,1,2)
plot(chebfun('3/(5+4*cos(x))',[0,2*pi]),LW,lw)
xlabel('$x$','interpreter','latex'), ylabel('$u_0(x)$','interpreter', 'latex')
title('Initial function')
clear

%% Fig.6: OK
figure
profile_ex2
clear

%% Fig.7: OK
load example2_result_20180719_134417.mat% This data is given by "advection_loop.m"
plotzu_ex2

%% Table 2: OK
disp('Table 2')
make_table_ex2

%% Example 3
% Fig.8: OK
figure
LW = 'linewidth';lw = 1.6;
subplot(2,1,1)
plot(chebfun('-1+0.3*sin(3*x)-0.19*cos(2*x)',[0,2*pi]),LW,lw)
xlabel('$x$','interpreter','latex')
ylabel('$c(x)$','interpreter', 'latex')
title('Variable coefficient')
subplot(2,1,2)
plot(chebfun('3/(5+4*cos(x))',[0,2*pi]),LW,lw)
xlabel('$x$','interpreter','latex'), ylabel('$u_0(x)$','interpreter', 'latex')
title('Initial function')
clear

%% Fig.9: OK
figure
profile_ex3
clear

%% Table 3: OK
disp('Table 3')
make_table_ex3