%% profile_ex1.m -- an executable m-file for solving a partial differential equation
% Automatically created in CHEBGUI by user takitoshi.
% Created on February 23, 2018 at 23:14.

%% Problem description.
% Solving
%   u_t = -(0.51+sin(x-1).^2)*u',
% for x in [0,6.2832] and t in [0,10], subject to periodic boundary conditions.

%% Problem set-up
% Create an interval of the space domain...
dom = [0 2*pi];
%...and specify a sampling of the time domain:
t = 0:.1:10;

% Make the right-hand side of the PDE.
pdefun = @(t,x,u) -(0.51+sin((x-1)).^2).*diff(u);

% Assign boundary conditions.
bc = 'periodic';

% Construct a chebfun of the space variable on the domain,
x = chebfun(@(x) x, dom);
% and of the initial condition.
u0 = exp(-100.*(x-1).^2);

%% Setup preferences for solving the problem.
opts = pdeset('Eps', 1e-6, 'Ylim', [0,3]);

%% Call pde23t to solve the problem.
[t, u] = pde23t(pdefun, t, u0, bc, opts);

%% Plot the solution.
% LW = 'linewidth';lw = 0.8;
waterfall(u,t)
view(10,70)
colormap([0,0,0])
axis([0,2*pi,0,10,0,1])
xlabel('$x$','interpreter','latex')
ylabel('$t$','interpreter','latex')
zlabel('$\tilde{u}(x,t)$','interpreter','latex')
grid off