%% load data
N=mid(sol_example2(:,1));
n=mid(sol_example2(:,2));
tmax=mid(sol_example2(:,3));
initerr=sup(sol_example2(:,4));
residual=sup(sol_example2(:,5));
err=sup(sol_example2(:,6));
app_time=sup(sol_example2(:,7));
time = sup(sol_example2(:,8));
LW = 'linewidth'; lw = 1.6;


%% Residual estimate: Fig.7
figure
Nmax = 150;
ipi = intval('pi');
ind01=find((tmax==.1).*(N==Nmax));
ind5=find((tmax==.5).*(N==Nmax));
ind10=find((tmax==1).*(N==Nmax));
indpi=find((tmax==mid(ipi)).*(N==Nmax));
ind2pi=find((tmax==mid(2*ipi)).*(N==Nmax));
ind4pi=find((tmax==mid(4*ipi)).*(N==Nmax));
% 
semilogy(n(ind01),residual(ind01),'o-',LW,lw)
hold on
semilogy(n(ind5),residual(ind5),'o-',LW,lw)
semilogy(n(ind10),residual(ind10),'o-',LW,lw)
semilogy(n(indpi),residual(indpi),'o-',LW,lw)
semilogy(n(ind2pi),residual(ind2pi),'o-',LW,lw)
semilogy(n(ind4pi),residual(ind4pi),'o-',LW,lw)
legend({'$t_{\max}=0.1$','$t_{\max}=0.5$','$t_{\max}=1.0$','$t_{\max}=\pi$','$t_{\max}=2\pi$','$t_{\max}=4\pi$'},'Interpreter','Latex')
xlabel('$n$','interpreter','latex'), ylabel('$\|r\|_{C((0,t_{\max});X)}$','interpreter', 'latex')
title('Residual estimates in Example 2')
grid on
hold off
